Option Strict Off
Option Explicit On
Module modGlobal
	'
	' File:       modGlobal.bas
	'
	' Purpose:    Simple program that demonstrates how to talk to the CAN232 in VB6
	'
	' Version:    Created 1.0.0, 7:th of April 2003
    '                     2.0.0, 18 of August 2008   Howard L Honig, Honey Software LLC
    '
	' Author:     Lars Wictorsson
	'             LAWICEL / SWEDEN
    '             http://www.lawicel.com/can232/   lars@lawicel.se
    '
    '             Modified by
    '             Howard Honig
    '             Honey Software LLC
    '             Corvallis, Oregon USA
    '
	' Copyright:  The copyright to the computer program(s) herein is the
    '             property of LAWICEL HB, Sweden and Honey Software LLC. 
    '             The program(s) may be used
	'             and/or copied only with the written permission of LAWICEL HB
	'             in accordance with the terms and conditions stipulated in
	'             the agreement/contract under which the program(s) have been
    '             supplied. FMV and HSW also owns this code and can do what they want
	'             with it.
	'
    ' History:    2003-04-07  1.0.0   Created (LWI)
    '             2008-09-02  2.0.0   Modified by H. Honig, Honey Software LLC
	'

    Enum CANPORTSTATUS
        CPS_UNKNOWN = 1
        CPS_CLOSED = 2
        CPS_OPEN = 3
    End Enum

    Public Const WM_SETTEXT As Long = &HC
    '


    Public iFlagACK As Short
    Public ComPortStatus As Short
    Public ComPortNo As Short
    Public ComPortSpeed As String
    Public CANSpeed As Short
    Public m_CANPortStatus As CANPORTSTATUS
    Public m_nFilter_PidLower As UInt32
    Public m_nFilter_PidUpper As UInt32
    Public m_bAutoPollSet As Boolean
    Public m_bPausePrinting As Boolean
    Public m_sFileName As String
    Public uSendTimer As Integer
    Public m_sTextResultBuffer As String

    Function SendCommand(ByRef sCommand As String) As Short
        If (frmMain.SerialPort1.IsOpen = False) Then
            OpenComPort()
            If (frmMain.SerialPort1.IsOpen = False) Then
                Return iFlagACK
            End If
        End If
        iFlagACK = 0

        'WriteLine includes the .SerialPort1.NewLine = Chr(13) character
        frmMain.SerialPort1.WriteLine(sCommand)

        ' This timer is put in as a crowbar to make sure nothing hangs

        frmMain.Timer1.Interval = 1000
        frmMain.Timer1.Enabled = True
        Do While (iFlagACK = 0) ' wait for CR or BELL
            System.Windows.Forms.Application.DoEvents()
        Loop
        frmMain.Timer1.Enabled = False
        SendCommand = iFlagACK
        Debug.Print("SendCommand = " & VB6.Format(iFlagACK, "0"))
    End Function


    Sub OpenComPort()
        On Error GoTo ErrOpen
        '
        ' COM port for CAN232
        '
        With frmMain
            If (ComPortStatus = 1) Then
                .SerialPort1.Close()
            End If
            .SerialPort1.PortName = "COM" & ComPortNo
            .SerialPort1.BaudRate = ComPortSpeed
            .SerialPort1.Parity = IO.Ports.Parity.None
            .SerialPort1.StopBits = IO.Ports.StopBits.One
            .SerialPort1.DataBits = 8
            .SerialPort1.Handshake = System.IO.Ports.Handshake.None
            .SerialPort1.ReadBufferSize = 1024
            .SerialPort1.ReceivedBytesThreshold = 1
            .SerialPort1.NewLine = Chr(13)
            'open it
            .SerialPort1.Open()
            If (.SerialPort1.IsOpen = True) Then
                ComPortStatus = 1
                frmMain.lbStatus_ComOpen.Text = "COM" & ComPortNo & " Status"
                frmMain.lbStatus_ComOpen.BackColor = Color.Green
            End If

        End With
        Exit Sub
ErrOpen:
        ComPortStatus = 0
        frmMain.lbStatus_ComOpen.BackColor = Color.Red

        MsgBox("Choose another COM port", MsgBoxStyle.Critical, "COM Port Error")
        On Error GoTo 0
    End Sub
End Module

Public Class StatusChecker
    Sub CheckStatus(ByVal stateInfo As Object)

    End Sub
End Class
